using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;

using System.Windows.Forms;


namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class DlgSelectIncomingShipment
	/// </summary>
	public class DlgSelectIncomingShipment : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private gov.va.med.vbecs.GUI.controls.InvoiceSelectTool invoiceSelectTool1;
		private System.Collections.ArrayList _alCollectionFacility;
		private BOL.ProductShipper _productShipper;
		private System.Windows.Forms.Button btnCancel;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.ComponentModel.IContainer components = null;
		private System.Windows.Forms.GroupBox groupBox1;
		private gov.va.med.vbecs.GUI.controls.BarcodeTextbox txtInvoice;
		private System.Windows.Forms.Label lblInvoice;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnSearch;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbSource;
		private System.Windows.Forms.Label lblSource;
		private System.Collections.ArrayList _incomingShipments;

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="alIncomingShipments"></param>
		public DlgSelectIncomingShipment(System.Collections.ArrayList alIncomingShipments)
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();

			SetComponentProperties();
			this._incomingShipments = alIncomingShipments;
			this.LoadCollectionFacilities();
			this.invoiceSelectTool1.InvoiceListSourceAL = alIncomingShipments;
			this.ActiveControl = this.txtInvoice;
		}
	
		/// <summary>
		/// Constructor
		/// </summary>
		public DlgSelectIncomingShipment()
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();

			SetComponentProperties();
			this.LoadCollectionFacilities();
			this.ActiveControl = this.txtInvoice;
		
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgSelectIncomingShipment));
			this.invoiceSelectTool1 = new gov.va.med.vbecs.GUI.controls.InvoiceSelectTool();
			this.btnCancel = new System.Windows.Forms.Button();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.cmbSource = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.lblSource = new System.Windows.Forms.Label();
			this.btnSearch = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.txtInvoice = new gov.va.med.vbecs.GUI.controls.BarcodeTextbox(this.components);
			this.lblInvoice = new System.Windows.Forms.Label();
			this.grpImage.SuspendLayout();
			this.groupBox1.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(444, 30);
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 313);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 6;
			// 
			// invoiceSelectTool1
			// 
			this.invoiceSelectTool1.AccessibleDescription = "Select Invoice";
			this.invoiceSelectTool1.AccessibleName = "Select Invoice";
			this.invoiceSelectTool1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.invoiceSelectTool1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.invoiceSelectTool1.IncomingShipment = false;
			this.invoiceSelectTool1.InvoiceListSource = null;
			this.invoiceSelectTool1.InvoiceListSourceAL = null;
			this.invoiceSelectTool1.Location = new System.Drawing.Point(64, 108);
			this.invoiceSelectTool1.Name = "invoiceSelectTool1";
			this.invoiceSelectTool1.Size = new System.Drawing.Size(380, 188);
			this.invoiceSelectTool1.TabIndex = 5;
			this.invoiceSelectTool1.UsingDataTable = true;
			this.invoiceSelectTool1.InvoiceDeselected += new System.EventHandler(this.invoiceSelectTool1_InvoiceDeselected);
			this.invoiceSelectTool1.InvoiceSelected += new System.EventHandler(this.invoiceSelectTool1_InvoiceSelected);
			this.invoiceSelectTool1.DoubleClicked += new System.EventHandler(this.invoiceSelectTool1_DoubleClicked);
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.CausesValidation = false;
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(364, 304);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.Size = new System.Drawing.Size(76, 23);
			this.btnCancel.TabIndex = 7;
			this.btnCancel.Text = "&Cancel";
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.EnabledButton = false;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = null;
			this.btnOK.Location = new System.Drawing.Point(284, 304);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 6;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.Controls.Add(this.pictureBox1);
			this.grpImage.Location = new System.Drawing.Point(4, 36);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(52, 260);
			this.grpImage.TabIndex = 5;
			this.grpImage.TabStop = false;
			// 
			// pictureBox1
			// 
			this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
			this.pictureBox1.Location = new System.Drawing.Point(4, 8);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(45, 45);
			this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox1.TabIndex = 36;
			this.pictureBox1.TabStop = false;
			// 
			// groupBox1
			// 
			this.groupBox1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.groupBox1.Controls.Add(this.cmbSource);
			this.groupBox1.Controls.Add(this.lblSource);
			this.groupBox1.Controls.Add(this.btnSearch);
			this.groupBox1.Controls.Add(this.txtInvoice);
			this.groupBox1.Controls.Add(this.lblInvoice);
			this.groupBox1.Location = new System.Drawing.Point(60, 36);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(380, 68);
			this.groupBox1.TabIndex = 1;
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = "Search Criteria*";
			// 
			// cmbSource
			// 
			this.cmbSource.AccessibleDescription = "Source Shipper";
			this.cmbSource.AccessibleName = "Source Shipper";
			this.cmbSource.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbSource.Interval = 500;
			this.cmbSource.Location = new System.Drawing.Point(108, 40);
			this.cmbSource.Name = "cmbSource";
			this.cmbSource.Size = new System.Drawing.Size(172, 22);
			this.cmbSource.TabIndex = 2;
			this.cmbSource.TextChanged += new System.EventHandler(this.cmbSource_TextChanged);
			this.cmbSource.SelectedValueChanged += new System.EventHandler(this.cmbSource_SelectedValueChanged);
			this.cmbSource.SelectedIndexChanged += new System.EventHandler(this.cmbSource_SelectedIndexChanged);
			// 
			// lblSource
			// 
			this.lblSource.Location = new System.Drawing.Point(8, 40);
			this.lblSource.Name = "lblSource";
			this.lblSource.Size = new System.Drawing.Size(120, 20);
			this.lblSource.TabIndex = 2;
			this.lblSource.Text = "Source (Shipper)";
			this.lblSource.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// btnSearch
			// 
			this.btnSearch.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnSearch.EnabledButton = false;
			this.btnSearch.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnSearch.Image = ((System.Drawing.Image)(resources.GetObject("btnSearch.Image")));
			this.btnSearch.Location = new System.Drawing.Point(296, 36);
			this.btnSearch.Name = "btnSearch";
			this.btnSearch.Size = new System.Drawing.Size(75, 23);
			this.btnSearch.TabIndex = 3;
			this.btnSearch.Click += new System.EventHandler(this.btnSearch_Click);
			// 
			// txtInvoice
			// 
			this.txtInvoice.AccessibleDescription = "Invoice Number";
			this.txtInvoice.AccessibleName = "Invoice Number";
			this.txtInvoice.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtInvoice.Barcode = false;
			this.txtInvoice.BarcodeType = gov.va.med.vbecs.Common.BarcodeType.None;
			this.txtInvoice.Location = new System.Drawing.Point(108, 16);
			this.txtInvoice.MaxLength = 14;
			this.txtInvoice.Name = "txtInvoice";
			this.txtInvoice.Size = new System.Drawing.Size(172, 20);
			this.txtInvoice.TabIndex = 1;
			this.txtInvoice.Text = "";
			this.txtInvoice.TextChanged += new System.EventHandler(this.txtInvoice_TextChanged);
			// 
			// lblInvoice
			// 
			this.lblInvoice.Location = new System.Drawing.Point(8, 16);
			this.lblInvoice.Name = "lblInvoice";
			this.lblInvoice.Size = new System.Drawing.Size(88, 20);
			this.lblInvoice.TabIndex = 0;
			this.lblInvoice.Text = "Invoice Number";
			this.lblInvoice.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// DlgSelectIncomingShipment
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(444, 329);
			this.Controls.Add(this.groupBox1);
			this.Controls.Add(this.grpImage);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.invoiceSelectTool1);
			this.Controls.Add(this.btnCancel);
			this.hlphelpChm.SetHelpKeyword(this, "Incoming_Shipment.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.Name = "DlgSelectIncomingShipment";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Select Invoice";
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.invoiceSelectTool1, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.grpImage, 0);
			this.Controls.SetChildIndex(this.groupBox1, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.grpImage.ResumeLayout(false);
			this.groupBox1.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		#region Properties

		/// <summary>
		/// Get ShipmentGuid
		/// </summary>
		public System.Guid ShipmentGuid
		{
			get
			{
				return this.invoiceSelectTool1.SelectedInvoice.ShipmentGuid;
			}
		}

		#endregion

		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			//
			this.btnOK.EnabledButton = false;
			this.btnOK.Text = "&OK";
			//
			this.btnSearch.EnabledButton = false;
			this.btnSearch.Text = "&Search";
			//
			this.invoiceSelectTool1.Text = "Search Results";
			this.invoiceSelectTool1.IncomingShipment = true;
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC001.DlgSelectIncomingShipment());
			
		}

		private void invoiceSelectTool1_InvoiceDeselected(object sender, System.EventArgs e)
		{
			this.btnOK.EnabledButton = false;
		}

		private void invoiceSelectTool1_InvoiceSelected(object sender, System.EventArgs e)
		{
			this.btnOK.EnabledButton = true;
		}

		

		private void btnOK_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void btnSearch_Click(object sender, System.EventArgs e)
		{
			this.invoiceSelectTool1.InvoiceListSourceAL = null;
			if(this.txtInvoice.Text.Trim().Length > 0 || this.cmbSource.Text.Trim().Length > 0)
			{
				this.invoiceSelectTool1.InvoiceListSourceAL = null;
                System.Collections.ArrayList alExistingShipments;
				if(this._productShipper == null)
				{
					alExistingShipments = BOL.IncomingShipment.GetIncomingShipments(this.txtInvoice.Text, System.Guid.Empty);
				}
				else
				{
					alExistingShipments = BOL.IncomingShipment.GetIncomingShipments(this.txtInvoice.Text, this._productShipper.LocalSupplierGuid);
				}					
				if(alExistingShipments != null)
				{
					if(alExistingShipments.Count > 0)
					{
						this.invoiceSelectTool1.InvoiceListSourceAL = alExistingShipments;
					}
					else
					{
						this.invoiceSelectTool1.InvoiceListSourceAL = null;
						GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC020.NoMatchingEntries());
					}
				}
			}
		}

		private void cmbSource_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if(this.cmbSource.SelectedIndex == 0)
			{
				if(this._productShipper != null)
				{
					try
					{
						this._productShipper.LocalSupplierGuid = System.Guid.Empty;
					}
					catch
					{
						//do nothing this is just a broken rulee exception
					}
				}
				return;
			}
			foreach(Object obj in this._alCollectionFacility)
			{
				this._productShipper = (BOL.ProductShipper) obj;
				if(this._productShipper.FacilityName.Trim() == cmbSource.Text.Trim())
				{
					break;
				}
			}
		
		}

		/// <summary>
		/// Loads collection facilities dropdown
		/// </summary>
		private void LoadCollectionFacilities()
		{
			cmbSource.Items.Clear();			
			_alCollectionFacility = BOL.ProductShipper.GetProductShippersByDivisionLookUpAL();
			cmbSource.Items.Add("");
			
			foreach(Object obj in this._alCollectionFacility)
			{
				BOL.ProductShipper ProductShipper = (BOL.ProductShipper) obj;
				cmbSource.Items.Add(ProductShipper.FacilityName);
			}
		}

		private void txtInvoice_TextChanged(object sender, System.EventArgs e)
		{
			this.btnSearch.EnabledButton = ((txtInvoice.Text.Trim().Length > 0) || (this.cmbSource.Text.Trim().Length > 0));
		}

		private void cmbSource_TextChanged(object sender, System.EventArgs e)
		{
			this.btnSearch.EnabledButton = ((txtInvoice.Text.Trim().Length > 0) || (this.cmbSource.Text.Trim().Length > 0));
		}

		private void cmbSource_SelectedValueChanged(object sender, System.EventArgs e)
		{
			this.btnSearch.EnabledButton = ((txtInvoice.Text.Trim().Length > 0) || (this.cmbSource.Text.Trim().Length > 0));
		}

	

		private void invoiceSelectTool1_DoubleClicked(object sender, System.EventArgs e)
		{
			this.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK_Click(sender, e);
		}
	}
}

